(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  14, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, R65535, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  10, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  10, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  10, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, B65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w245, h249,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	paletteColors = 128; automaticGrouping; currentKernel; 
]
:[font = title; inactive; locked; preserveAspect; startGroup]
A Simple Search Engine for an Unstructured Quantum Computing Database
:[font = subsubtitle; inactive; locked; preserveAspect]
Colin P. Williams
:[font = input; initialization; preserveAspect]
*)
Off[General::spell1]
(*
:[font = section; inactive; locked; preserveAspect; startGroup]
Copyright Notice
:[font = text; inactive; locked; preserveAspect; endGroup]
Copyright Colin P. Williams (1997).

This Notebook is intended to be used in conjunction with "Explorations in Quantum Computing" by Colin P. Williams and Scott H. Clearwater, TELOS, Springer-Verlag (1997), ISBN:0-387-94768-X. Permission is hereby granted to copy and distribute this Notebook freely for any non-commercial activity provided you include this copyright notice at the beginning of all such copies. Please send suggestions and bug reports to Colin P. Williams at 
        colin@solstice.jpl.nasa.gov      (818) 306 6512 or 
        cpw@cs.stanford.edu               (415) 728 2118
For information on "Explorations in Quantum Computing" check out the TELOS web site:  http://www.telospub.com/catalog/PHYSICS/Explorations.html. To order call 1-800-777-4643.

All other rights reserved.
:[font = section; inactive; preserveAspect; startGroup]
How to use this Notebook
:[font = text; inactive; preserveAspect]
This Notebook contains code for searching a database of references to papers in quantum computing.  The field is growing so rapidly that this database will surely need to be updated over the coming months.  Unlike the Los Alamos National Laboratory  archive (http://xxx.lanl.gov/archive/quant-ph/) this database contains many of the classic, older,  references on quantum computing and quantum communication.  We hope it will be a useful adjunct to the modern on-line archives.

The basic command is Search. The following types of query are supported:
:[font = input; preserveAspect]
Search[Lloyd]              (* returns all papers by Lloyd *)
Search[{Doyle, Laflamme}]  (* returns all papers by Doyle OR Laflamme *)
Search[Adami || Fahn]      (* returns all papers by Adami OR Fahn (same as previous) *)
Search[Shor && Not[Code]]  (* return Shor papers not about codes *)
Search[Teleport]           (* return papers containing keyword Teleport *)
:[font = text; inactive; preserveAspect]
Before you can run the search engine, you will need to set your directory to the pathname leading to the place where you have the quantum computing database. For example, on my Macintosh computer I would do this with the command:
:[font = input; preserveAspect]
SetDirectory["Hard Disk:Desktop Folder:Documents:Mathematica 2.2.2:EiQC Code"];
:[font = text; inactive; preserveAspect]
You need to replace the string with a string that defines a directory on your computer system. On UNIX systems the directory separator is "/" (a forward slash). On PCs the directory separator is "\" (a backwards slash). Check the usage statements for the Directory and SetDirectory commands.
:[font = input; preserveAspect; startGroup]
?Directory
:[font = print; inactive; preserveAspect; endGroup]
Directory[ ] gives the current working directory.
:[font = input; preserveAspect; startGroup]
?SetDirectory
:[font = print; inactive; preserveAspect; endGroup]
SetDirectory["dir"] sets the current working directory.
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
To find out how to use Search, type ?Search
:[font = input; preserveAspect; startGroup]
?Search
:[font = print; inactive; preserveAspect; endGroup; endGroup]
Search[query] returns all known citations that satisfy your query. The query may
   consist of a single keyword, a list (implicit disjunction) of keywords, or a
   logical sentence built out of keywords and the infix operators && (for logical
   conjunction) and/or || (for logical disjunction), and the prefix operator Not (for
   logical negation).
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = input; preserveAspect; startGroup]
Search[Teleport]
:[font = print; inactive; preserveAspect; endGroup; endGroup]
Bennett, C. H., Brassard, G., Crepeau, C., Jozsa, R., Peres, A., Wootters, W. K. 
	"Teleporting an Unknown Quantum State via Dual Classical and Einstein-Podolsky-Rosen Channels"
	Physical Review Letters, Vol. 70 (1993) pp. 1895-1899.


Bennett, C. H., Brassard, G., Popescu, S., Schumacher, B., Smolin, J. A., Wootters, W. K. 
	"Purification of Noisy Entanglement and Faithful Teleportation"
	Physical Review Letters, Vol. 76 (1996) pp. 722-725.


Bennett, C. H., Brassard, G., Crepeau, C., Jozsa, R., Peres, A., Wooters, W., 
	"Teleporting an Unknown Quantum State via Dual Classical and Einstein-Podolsky-Rosen Channels"
	 Physical Review Letters, Vol. 70 (1993) pp.1895-1899.


Peterson, I., 
	"Inspecting Teleported Quantum Information"
	Science News, April, 1993 p. 229.


Popescu, S. 
	"Bell's Inequality versus Teleportation: What is Nonlocality?"
	Physical Review Letters, Vol. 72 (1994) pp.797-799.


Sudbury, T., 
	"Instant Teleportation"
	 Nature vol.362 (1993) pp. 586-587.


:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = input; preserveAspect; startGroup]
Search[Deutsch && Jozsa]
:[font = print; inactive; preserveAspect; endGroup; endGroup; endGroup]
Deutsch, D. and Jozsa, R. 
	"Rapid Solution of Problems by Quantum Computation"
	Proceedings of the Royal Society of London,  Vol. 439A (1992) pp. 553-558.


Deutsch, D., Ekert, A., Jozsa, R., Macchiavello, C., Popescu, S., Sanpera, A. 
	"Quantum Privacy Amplification and the Security of Quantum Cryptography Over Noisy Channels"
	Physical Review Letters, Vol. 77 (1996) pp. 2818-2821.


:[font = section; inactive; preserveAspect; startGroup]
Code for Search Engine in here ...
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
Search[query_]:=
	Module[{hits},
		SetOptions[$Output, PageWidth->Infinity];
		SetDirectory["Hard Disk:Desktop Folder:Documents:Mathematica 2.2.2:EiQC Code"];
		hits = Lookup["QCdatabase.txt", query];
		If[hits === {},
		   Print["Sorry, no citations satisfy that query. Try re-wording it."],
		   (* Scan[(Print[#];Print["\n\n\n"])&, hits] *)
		   Scan[PrintCitation, hits]
		  ]
	]

Search[query_String]:=
	Search[ToExpression[query]]

Search::usage =
	"Search[query] returns all known citations that satisfy your query. \
	The query may consist of a single keyword, a list (implicit disjunction) \
	of keywords, or a logical sentence built out of keywords and the \
	infix operators && (for logical conjunction) and/or || (for logical \
	disjunction), and the prefix operator Not (for logical negation).";
	
(* Lookup does most of the work *)	
Lookup[database_, keyword_Symbol]:=
	FindList[ToString[database], ToString[keyword]]

Lookup[database_, keywords_List]:=  (* implicit Or of keywords *)
	FindList[ToString[database], Map[ToString, keywords]]
	
Lookup[database_, keyword_ && keywords__]:=
	Apply[Intersection,
	      Map[Lookup[database, #]&, Apply[List, keyword && keywords]]]

Lookup[database_, keyword_ || keywords__]:=
	Lookup[database, Apply[List, keyword || keywords]]
	
Lookup[database_, Not[keyword_ && keywords__]]:=
	Lookup[database, Not[keyword] || Not[keywords]]
	
Lookup[database_, Not[keyword_ || keywords__]]:=
	Lookup[database, Not[keyword] && Not[keywords]]
	
Lookup[database_, Not[keyword_]]:=
	Module[{allEntries},
		allEntries = ReadList[ToString[database],
		                      Record,
		                      RecordSeparators->{"\n"}];  (* bad for big DBs *)
		Select[allEntries, 
		       Not[StringMatchQ[#, "*"<>ToString[keyword]<>"*"]]&]
	]
	
PrintCitation[citation_]:=
	Module[{pos, startTitle, endTitle, authors, title, others},
		pos = StringPosition[citation, "\""];
		If[pos =!= {},
			(startTitle = First[pos][[1]];
			 endTitle   = Last[pos][[1]];
			 authors = StringTake[citation, {1, startTitle-1}];
			 title   = StringTake[citation, {startTitle, endTitle}];
			 others  = StringDrop[citation, {1, endTitle+1}];
			 Print[authors];
			 Print["\t"<>title];
			 Print["\t"<>others];
			 Print["\n"]
			),
			Print[citation<>"\n"]
		  ]
	]
	

(* This form of partition retains trailing elements *)	
PartitionWithRmdr[list_, n_]:=
	Module[{leftovers},
		If[Mod[Length[list], n] != 0,
			(leftovers = Take[list, -Mod[Length[list], n]];
			 Join[Partition[list, n], {leftovers}]
			),
			Partition[list, n]
		  ]
	]
(*
^*)
